/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.ai.attack;

import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.Vec3d;
import noppes.npcs.CustomNpcs;
import noppes.npcs.ai.attack.EntityAICustom;
import noppes.npcs.api.util.IRayTraceVec;
import noppes.npcs.util.Util;

public class EntityAIHitAndRun
extends EntityAICustom {
    private int[] runPos;

    public EntityAIHitAndRun(IRangedAttackMob npc) {
        super(npc);
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        if (this.isFriend || this.npc.field_70173_aa % (this.tickRate * 2) > 3) {
            return;
        }
        this.canSeeToAttack = this.isRanged ? Util.instance.npcCanSeeTarget((EntityLivingBase)this.npc, this.target, true, true) : this.npc.canSee((Entity)this.target);
        if (this.canSeeToAttack && this.distance <= this.range) {
            if (this.inMove) {
                if (this.runPos == null) {
                    this.npc.func_70661_as().func_75499_g();
                } else {
                    PathPoint point = Objects.requireNonNull(this.npc.func_70661_as().func_75505_d()).func_75870_c();
                    if (point == null || point.field_75839_a < this.runPos[0] - 2 && point.field_75839_a > this.runPos[0] + 2 || point.field_75837_b < this.runPos[1] - 2 && point.field_75837_b > this.runPos[1] + 2 || point.field_75838_c < this.runPos[2] - 2 && point.field_75838_c > this.runPos[2] + 2) {
                        this.runPos = null;
                        this.npc.func_70661_as().func_75499_g();
                    }
                }
            }
        } else if (!this.inMove) {
            this.runPos = null;
            this.tryMoveToTarget();
        }
        this.tryToCauseDamage();
        if (this.hasAttack) {
            Path path = null;
            this.runPos = null;
            if (!this.isRanged || this.distance < (double)this.tacticalRange) {
                Vec3d vec;
                IRayTraceVec pos = Util.instance.getPosition(this.target.field_70165_t, this.target.field_70163_u, this.target.field_70161_v, this.target.field_70177_z + 180.0f, this.target.field_70125_A, this.tacticalRange);
                path = this.npc.func_70661_as().func_75488_a(pos.getX(), pos.getY(), pos.getZ());
                if (path == null && (vec = RandomPositionGenerator.func_75463_a((EntityCreature)this.npc, (int)this.tacticalRange, (int)2)) != null) {
                    path = this.npc.func_70661_as().func_75488_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                }
            }
            if (path == null) {
                double dist = 0.0;
                int error = 0;
                int attempts = 0;
                while (true) {
                    double homeDist;
                    if (!(dist < (double)this.tacticalRange)) {
                        double d = this.isRanged ? this.range / 2.0 : this.range;
                        if (!(dist < d) && !(dist > (double)this.npc.stats.aggroRange)) break;
                    }
                    if (error >= 3 || attempts >= 8) break;
                    ++attempts;
                    Vec3d vec = RandomPositionGenerator.func_75463_a((EntityCreature)this.npc, (int)this.tacticalRange, (int)2);
                    if (vec == null) {
                        ++error;
                        continue;
                    }
                    error = 0;
                    dist = this.npc.func_70011_f(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                    if (this.npc.stats.calmdown && (homeDist = Util.instance.distanceTo(this.npc.getStartXPos(), this.npc.getStartYPos(), this.npc.getStartZPos(), vec.field_72450_a, vec.field_72448_b, vec.field_72449_c)) > (double)CustomNpcs.NpcNavRange) continue;
                    if ((int)vec.field_72450_a == this.npc.func_180425_c().func_177958_n() && (int)vec.field_72448_b == this.npc.func_180425_c().func_177956_o() && (int)vec.field_72450_a == this.npc.func_180425_c().func_177952_p()) {
                        dist = 0.0;
                        continue;
                    }
                    path = this.npc.func_70661_as().func_75488_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
                    if (path == null) {
                        dist = 0.0;
                        continue;
                    }
                    if (this.runPos == null) {
                        this.runPos = new int[]{(int)vec.field_72450_a, (int)vec.field_72448_b, (int)vec.field_72449_c};
                        continue;
                    }
                    this.runPos[0] = (int)vec.field_72450_a;
                    this.runPos[1] = (int)vec.field_72448_b;
                    this.runPos[2] = (int)vec.field_72449_c;
                }
            }
            if (path != null) {
                this.npc.func_70661_as().func_75484_a(path, 1.3);
                PathPoint point = path.func_75870_c();
                if (point != null) {
                    if (this.runPos == null) {
                        this.runPos = new int[]{point.field_75839_a, point.field_75837_b, point.field_75838_c};
                    } else {
                        this.runPos[0] = point.field_75839_a;
                        this.runPos[1] = point.field_75837_b;
                        this.runPos[2] = point.field_75838_c;
                    }
                }
            }
        }
    }
}

